@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-water-quality-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $args = [
    'post_type' => 'water_quality',
    'post_status' => 'publish',
    'orderby' => 'title',
    'order' => 'ASC',
    'posts_per_page' => 1000,
  ];
  $comuni = new WP_Query( $args );

  $meta_keys = [
    'pick_up_point' => __('Punto di prelievo', 'thor'),
    'ph' => __('PH', 'thor'),
    'fixed_residue' => __('Residuo Fisso a 180°C', 'thor'),
    'hardness' => __('Durezza', 'thor'),
    'conductivity' => __('Conducibilità', 'thor'),
    'calcium' => __('Calcio', 'thor'),
    'magnesium' => __('Magnesio', 'thor'),
    'ammonium' => __('Ammonio', 'thor'),
    'chlorides' => __('Cloruri', 'thor'),
    'sulfates' => __('Solfati', 'thor'),
    'potassium' => __('Potassio', 'thor'),
    'sodium' => __('Sodio', 'thor'),
    'arsenic' => __('Arsenico', 'thor'),
    'bicarbonate' => __('Bicarbonato', 'thor'),
    'residual_chlorine' => __('Cloro residuo', 'thor'),
    'fluorides' => __('Fluoruri', 'thor'),
    'nitrates' => __('Nitrati', 'thor'),
    'nitrites' => __('Nitriti', 'thor'),
    'manganese' => __('Manganese', 'thor'),
  ];
  $reference_values = [
    'pick_up_point' => __('Valore di parametro D.Lgs 31/2001', 'thor'),
    'ph' => __('6,5 - 9,5', 'thor'),
    'fixed_residue' => '',
    'hardness' => '',
    'conductivity' => __('2500', 'thor'),
    'calcium' => '',
    'magnesium' => '',
    'ammonium' => __('0,5', 'thor'),
    'chlorides' => __('250', 'thor'),
    'sulfates' => __('250', 'thor'),
    'potassium' => '',
    'sodium' => __('200', 'thor'),
    'arsenic' => __('10', 'thor'),
    'bicarbonate' => '',
    'residual_chlorine' => '',
    'fluorides' => __('1,5', 'thor'),
    'nitrates' => __('50', 'thor'),
    'nitrites' => __('0,5', 'thor'),
    'manganese' => __('50', 'thor'),
  ];
  $unit_values = [
    'pick_up_point' => __('Unità di misura', 'thor'),
    'ph' => __('', 'thor'),
    'fixed_residue' => __('mg/l', 'thor'),
    'hardness' => __('°F', 'thor'),
    'conductivity' => __('μS/cm', 'thor'),
    'calcium' => __('mg/l Ca', 'thor'),
    'magnesium' => __('mg/l Mg', 'thor'),
    'ammonium' => __('mg/l NH4', 'thor'),
    'chlorides' => __('mg/l Cl', 'thor'),
    'sulfates' => __('mg/l SO4', 'thor'),
    'potassium' => __('mg/l K', 'thor'),
    'sodium' => __('mg/l Na', 'thor'),
    'arsenic' => __('μg/l As', 'thor'),
    'bicarbonate' => __('mg/l HCO₃', 'thor'),
    'residual_chlorine' => __('mg/l Cl₂', 'thor'),
    'fluorides' => __('mg/l F', 'thor'),
    'nitrates' => __('mg/l NO₃', 'thor'),
    'nitrites' => __('mg/l NO₂', 'thor'),
    'manganese' => __('μg/l Mn', 'thor'),
  ];

@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">

  <table class="water-quality-table"
    style="width: 100%"
  >
    <thead>
      <tr>
        <th rowspan="3">{!! __('Comune', 'thor') !!}</th>
        @foreach ($meta_keys as $key => $title)  
          <th>{!! $title !!}</th>
        @endforeach
      </tr>
      <tr class="header-secondary">
        @foreach ($unit_values as $key => $title)  
          <th>{!! $title !!}</th>
        @endforeach
      </tr>
      <tr class="header-secondary">
        @foreach ($reference_values as $key => $title)  
          <th>{!! $title !!}</th>
        @endforeach
      </tr>
    </thead>
    <tbody>
      @while ($comuni->have_posts())
        @php
          $comuni->the_post();
        @endphp
        <tr>
          <td>
            <strong>
              {!! get_the_title() !!}
            </strong>
          </td>
          @foreach ($meta_keys as $key => $title)  
            <td>
              {!! get_post_meta( get_the_ID(), $key, true); !!}
            </td>
          @endforeach
        </tr>
      @endwhile
    </tbody>
  </table>
</div>