@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-municipality-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $args = [
    'post_type' => 'comuni',
    'post_status' => 'publish',
    'orderby' => 'title',
    'order' => 'ASC',
    'posts_per_page' => 1000,
  ];
  $comuni = new WP_Query( $args );

  $comuni_data = [];

  $columns = [
    [
      'data' => 'title',
      'title' => __('Comune', 'thor'),
    ],
    [
      'data' => 'link',
      'title' => __('link', 'thor'),
    ]
  ];
  
  while ($comuni->have_posts()) {
    $comuni->the_post();

    $comune_data = [];
    $comune_data['title'] = get_the_title();
    $comune_data['link'] = get_permalink();


    $comuni_data[] = $comune_data;
  };
  wp_reset_postdata();
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">
  <table class="municipality-table"
    data-columns="{!! esc_attr(json_encode($columns)) !!}"
    data-data="{!! esc_attr(json_encode($comuni_data)) !!}"
  >
  </table>
</div>