@php
  // $term

  $args = [
    'post_type' => 'rates',
    'post_status' => 'publish',
    'orderby' => 'title',
    'order' => 'ASC',
    'posts_per_page' => 1000,
    'tax_query' => [
      [
        'taxonomy' => $term->taxonomy,
        'field' => 'slug',
        'terms' => $term->slug,
      ]
    ],
  ];
  $rates = new WP_Query( $args );

  $rates_data = [];
  $meta_keys = [
    'preferential_rate' => __('Tariffa Agevolata', 'thor'),
    'basic_rate' => __('Tariffa Base', 'thor'),
    'first_rate' => __('1° supero', 'thor'),
    'second_rate' => __('2° supero', 'thor'),
  ];

  $columns = [
    [
      'data' => 'title',
      'title' => __('Comune', 'thor'),
    ]
  ];
  foreach ($meta_keys as $key => $title) {
    $columns[] = [
      'data' => $key,
      'title' => $title,
    ];
  }
  
  while ($rates->have_posts()) {
    $rates->the_post();

    $rate_data = [];
    $rate_data['title'] = get_the_title();

    foreach ($meta_keys as $key => $value) {
      $rate_data[$key] = get_post_meta( get_the_ID(), $key, true);
    }

    $rates_data[] = $rate_data;
  };
  wp_reset_postdata();
@endphp

<table class="rates-table"
  data-columns="{!! esc_attr(json_encode($columns)) !!}"
  data-data="{!! esc_attr(json_encode($rates_data)) !!}"
></table>