@extends('layouts.app')

@section('content')
  @include('partials.info-numbers')
  @include('partials.header-second')
  @include('partials.ticker')

  @php
    $split_subcategories = get_field('split_subcategories', get_queried_object());
  @endphp


  <div class="container archive-header thor-maxwidth-lg">
    @if ( function_exists('yoast_breadcrumb') )
      @php yoast_breadcrumb( '<p class="breadcrumbs">','</p>' ); @endphp
    @endif
    <h1 class="archive-title">@php single_cat_title() @endphp</h1>
  </div>

  @if(!$split_subcategories)
    <div class="archive-items">
      <div class="items-wrapper">
        @if (!have_posts())
          <div class="alert alert-warning">
            {{ __('Sorry, no results were found.', LANG_DOMAIN) }}
          </div>
          {!! get_search_form(false) !!}
        @else
          @while (have_posts()) @php the_post() @endphp
            @include('partials.teaser-category')
          @endwhile
          @php wp_reset_postdata() @endphp
        @endif
      </div>
    </div>
  @else
    @php
      $terms = get_terms( 'category', array( 
        'child_of' => get_queried_object()->term_id,
        'order_by' => 'name',
        'order' => 'DESC',
      ) );

    @endphp
      @foreach($terms as $key => $term)
          @php
              $term_data = get_term($term, 'category');
              $args = array(
                'category__in' => array($term->term_id),
                'numberposts' => -1,
              );
              $posts = get_posts($args);
          @endphp
              <div class="archive-items">
                @if($posts)
                    <h2 id="{!! $taxonomy_data->slug . '-' . $term_data->slug  !!}" class="subcategory-title">
                        {!! $term_data->name !!}
                    </h2>
                <div class="items-wrapper">
                  @php
                    global $post;
                  @endphp
                  @foreach($posts as $key => $post)
                      <div>
                        @include('partials.teaser-category', ['post' => $post])
                      </div>
                  @endforeach
                </div>
              </div>
          @endif
      @endforeach
  @endif
@endsection