@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-chart-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  // $bubbles = get_field( 'bubbles' );
  // $under_bubbles = get_field( 'under_bubbles' );
  // var_dump($bubbles);

  $wd_block_colors = [
      "primary"         => "#00a5f4",
      "primary-light"  => "#00c1f6",
      "primary-dark" => "#004589",
      "green-500"         => "#4bb817",
      "orange-500"        => "#ff7e16",
      "gray-500"        => "#999999",
      "gray-300"        => "#f5f5f5",
      "white"        => "#fff",
      "black"   => "#000",
  ];

  // foreach( $wd_block_colors as $key => $value ) {
  //     if( $wd_acf_color_picker_values == $value ) {
  //           $wd_color_class = $key;
  //     }
  // }

  $center_chart_content = get_field( 'center_chart_content' );
  $slices = get_field( 'slice' );
  $slice_one_color = $slices[0]['slice_color'];
  $slice_one_value = $slices[0]['slice_value'];
  $slice_two_color = $slices[1]['slice_color'];
  $slice_two_value = $slices[1]['slice_value'];
  $slice_three_color = $slices[2]['slice_color'];
  $slice_three_value = $slices[2]['slice_value'];
  $slice_four_color = $slices[3]['slice_color'];
  $slice_four_value = $slices[3]['slice_value'];
  $slice_five_color = $slices[4]['slice_color'];
  $slice_five_value = $slices[4]['slice_value'];
  $slice_six_color = $slices[5]['slice_color'];
  $slice_six_value = $slices[5]['slice_value'];
  $slice_seven_color = $slices[6]['slice_color'];
  $slice_seven_value = $slices[6]['slice_value'];
  $slice_eight_color = $slices[7]['slice_color'];
  $slice_eight_value = $slices[7]['slice_value'];
  $slice_nine_color = $slices[8]['slice_color'];
  $slice_nine_value = $slices[8]['slice_value'];
  $slice_ten_color = $slices[9]['slice_color'];
  $slice_ten_value = $slices[9]['slice_value'];


  $legenda_chart = get_field( 'legenda_chart' );
  $legenda_label = get_field( 'legenda_label' );
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}"
  @if($slice_one_color) data-slice-one-color="{!! $slice_one_color !!}" @endif
  @if ($slice_one_value)
    data-slice-one-value="{!! $slice_one_value !!}"
  @endif
  @if($slice_two_color) data-slice-two-color="{!! $slice_two_color !!}" @endif
  @if ($slice_two_value)
    data-slice-two-value="{!! $slice_two_value !!}"
  @endif
  @if($slice_three_color) data-slice-three-color="{!! $slice_three_color !!}" @endif
  @if ($slice_three_value)
    data-slice-three-value="{!! $slice_three_value !!}"
  @endif
  @if($slice_four_color) data-slice-four-color="{!! $slice_four_color !!}" @endif
  @if ($slice_four_value)
    data-slice-four-value="{!! $slice_four_value !!}"
  @endif
  @if($slice_five_color) data-slice-five-color="{!! $slice_five_color !!}" @endif
  @if ($slice_five_value)
    data-slice-five-value="{!! $slice_five_value !!}"
  @endif
  @if($slice_six_color) data-slice-six-color="{!! $slice_six_color !!}" @endif
  @if ($slice_six_value)
    data-slice-six-value="{!! $slice_six_value !!}"
  @endif
  @if($slice_seven_color) data-slice-seven-color="{!! $slice_seven_color !!}" @endif
  @if ($slice_seven_value)
    data-slice-seven-value="{!! $slice_seven_value !!}"
  @endif
  @if($slice_eight_color) data-slice-eight-color="{!! $slice_eight_color !!}" @endif
  @if ($slice_eight_value)
    data-slice-eight-value="{!! $slice_eight_value !!}"
  @endif
  @if($slice_nine_color) data-slice-nine-color="{!! $slice_nine_color !!}" @endif
  @if ($slice_nine_value)
    data-slice-nine-value="{!! $slice_nine_value !!}"
  @endif
  @if($slice_ten_color) data-slice-ten-color="{!! $slice_ten_color !!}" @endif
  @if ($slice_ten_value)
    data-slice-ten-value="{!! $slice_ten_value !!}"
  @endif
>

  <div class="ct-chart ct-class-chart-pie">
    <div class="center-chart-content">
      <span class="number">
        {!! $center_chart_content[0]['number'] !!}
      </span>

      <p>
        {!! $center_chart_content[0]['label'] !!}
      </p>
    </div>

    @if ($legenda_label)
      <div class="legenda-label">
        {!! $legenda_label !!}
      </div>
    @endif

    <div class="legenda-wrapper">
      @foreach ($slices as $slice)
        <div class="legenda">
          <div class="color-badge"
            @if($slice['slice_color'])
              style="background-color: {!! $slice['slice_color'] !!};"
            @endif>
          </div>
          <span class="number">{!! $slice['slice_value'] !!}</span>
          <p class="label">{!! $slice['legenda'] !!}</p>
        </div>
      @endforeach

      <div class="separator"></div>
    </div>
  </div>
</div>
