@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-accordion-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $icon = get_field('accordion_icon');
  $label = get_field('accordion_label');
  $accordion_sync = get_field('accordion_sync');
  $accordion_title_color = get_field('accordion_title_color');
  $accordion_background_color = get_field('accordion_background_color');
  
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}" data-accordion-group="{!! $accordion_sync !!}">
  <div class="accordion-block-inner">
    <button
     class="accordion-header"
     style="background: {!! $accordion_background_color !!}">

      <p style="color: {!! $accordion_title_color !!}" class="accordion-title">
        {!! $label !!}
      </p>
      <img class="accordion-arrow" src="@asset('images/accordion-arrow.svg')"/> 
    </button>

    <div class="accordion-content">
      <InnerBlocks />
    </div>

  </div>
</div>