import 'datatables.net'

export default (() => {
  $.fn.DataTable.ext.pager.numbers_length = 5;

  const blocks = $('.thor-rates');
  const buttonTaxonomy = $('.button-taxonomy');
  const ratesPanel = $('.rates-panel');
  const d = new Date();
  const lastYear = d.getFullYear() - 1;


  blocks.each( function() {
    const table = $(this).find('.rates-table');
    const columns = table.data('columns')
    const data = table.data('data')

    table.DataTable(
      {
        data,
        columns,
        fixedColumns: true,
        responsive: true,
        pageLength: 20,
        language: {
          search: '_INPUT_',
          searchPlaceholder: 'Cerca comune',
          zeroRecords: 'Nessun comune trovato',
          paginate: {
            first: '1',
            previous: '<',
            next: '>',
            last: '»',
          },
        },
      }
    );
  })

  buttonTaxonomy.each(function (index) {
    const currentbuttonTaxonomy = $(this).data();

    if (lastYear == currentbuttonTaxonomy.target) {
      $(this).addClass('active');
    }
  });

  ratesPanel.each(function (index) {
    const currentRatesPanel = $(this).data();

    if (lastYear == currentRatesPanel.term) {
      $(this).addClass('active');
    }
  });


  buttonTaxonomy.on('click', function (e) {
    const currentButtonTaxonomy = $(this);
    const buttonTaxonomyValue = $(this).data();

    ratesPanel.each(function (index) {
      const currentRatesPanel = $(this).data();

      if (buttonTaxonomyValue.target == currentRatesPanel.term) {
        buttonTaxonomy.removeClass('active');
        currentButtonTaxonomy.addClass('active');
        ratesPanel.removeClass('active');
        $(this).addClass('active');
      }
    });
  });
})();