@php
  $post_date = get_the_date( '', get_the_ID() );
@endphp

<article {!! post_class('single-post-wrapper') !!}>
  @include('partials.info-numbers')
  @include('partials.header-second')
  @include('partials.ticker')
  @include('partials/page-header')


  <div class="container thor-maxwidth-lg">
    <div class="date desktop">
      {!! ucfirst($post_date); !!}
    </div>

    <div class="single-post-inner clearfix">
      
      <figure class="main-image lightbox">
        <a href="{!! get_the_post_thumbnail_url(get_the_ID(), 'full') !!}">
          <img
            class="lazy"
            src="{!! get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') !!}"

            data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"

          />
        </a>
      </figure>

      <div class="post-content-wrapper">
        {!! the_content() !!}
      </div>
    </div><!--single-post-inner-->
  </div><!--container-->
</article>
