@extends('layouts.app')

@section('content')
  @include('partials.info-numbers')
  @include('partials.header-second')
  @include('partials.ticker')
  @include('partials.page-header')

  <div class="container">
    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'thor') }}
      </div>
      {!! get_search_form(false) !!}
    @else
      <div class="-mx-4 row">
        @while (have_posts()) @php the_post() @endphp
          <div class="w-full px-4 md__w-1/2 xl__w-1/4">
            @include('partials.teaser-'.get_post_type())
          </div>
        @endwhile
      </div><!--row-->
    @endif

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
