@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-step-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $number = get_field('number');
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">
  <div class="step-number">
    {!! $number !!}
  </div>

  <div class="step-content">
    <InnerBlocks />
  </div>
</div>