import Swiper from 'swiper';
// core version + navigation, pagination modules:
import SwiperCore, { Navigation, Pagination, Autoplay, EffectFade} from 'swiper/core';
// configure Swiper to use modules
SwiperCore.use([Navigation, Pagination, Autoplay, EffectFade]);

export default (() => {
  const sliders = $('.thor-slider');

  sliders.each(function() {
    const sliderData = $(this).data();
    const slider = $(this).find('.swiper-container')

    new Swiper(slider[0], {
      slidesPerView: 1,
      loop: sliderData['swiperLoop'] || false,
      allowTouchMove: true,
      autoplay: sliderData['swiperPlay'] || false,
      effect: sliderData['swiperFade'] || 'fade',
      navigation: {
        nextEl: '.custom-button-next',
        prevEl: '.custom-button-prev',
      },
      pagination: {
        el: '.swiper-pagination',
        clickable: true,
        type: 'bullets',
      },
      breakpoints: {
        768: {
          allowTouchMove: false,
        },
      },
    });

  })
})()