@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-slider-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $default_slides = array(
    array(
      'text'  => __('Insert first slide', 'thor'),
    ),
  );

  $slides = get_field('slides') ?: $default_slides;
  $dots = get_field('dots');
  $dots_hide_mobile = get_field('dots_hide_mobile');
  $dots_hide_desktop = get_field('dots_hide_desktop');
  $arrows = get_field('arrows');
  $arrows_hide_mobile = get_field('arrows_hide_mobile');
  $autoplay = get_field('autoplay');
  $infinite = get_field('infinite');
  $autoplay_delay = get_field('autoplay_time');
  $fade = get_field('fade');
  $wave = get_field('wave');
@endphp

@if ($is_preview)
  <ul class="slides-list-preview">
    @foreach ($slides as $slide)
      @if ($slide['image'])
        <li>
          <figure>
            @if ($slide['image'])
              <img src="{!! $slide['image']['sizes']['medium'] !!}" />
            @endif
          </figure>
        </li>
      @endif
    @endforeach
  </ul>
@else
    
  <div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}"
  @if($autoplay)
    data-swiper-play="true"
    data-swiper-touch="false"
  @endif
  @if(!$autoplay)
    data-swiper-play="false"
    data-swiper-touch="false"
  @endif
  @if($infinite)
    data-swiper-loop="true" 
  @endif
  @if(!$infinite)
    data-swiper-loop="false" 
  @endif 
  @if($fade) 
    data-swiper-fade="fade"
  @endif
  @if(!$fade)
    data-swiper-fade=""
  @endif>
    @if ($slides)
      <div class="swiper-container">
        @if ($arrows)
          <div class="button-wrapper  {{ !$arrows_hide_mobile ?: 'hide' }}">
            <div class="custom-button-prev">
              <img src="@asset('images/arrow-slider-left.svg')" alt="{{ __('circle-arrow-left', 'thor') }}">
            </div>
            <div class="custom-button-next">
              <img src="@asset('images/arrow-slider-right.svg')" alt="{{ __('circle-arrow-right', 'thor') }}">
            </div>
          </div>
        @endif

        <div class="swiper-wrapper">
          @foreach ($slides as $slide)
            @if ($slide['image'])
              <div class="swiper-slide {!! $slide['text'] ? 'slide-has-text' : 'slide-no-text' !!}" data-swiper-autoplay="{!! $autoplay_delay !!}">
                <figure
                  class="{{ $slide['opacity'] ? 'bg-opacity' : ''}}"
                  style="{{ $slide['opacity'] ? 'background-color: black;' : '' }}">
                  @if ($slide['image'])
                    <img src="{!! $slide['image']['sizes']['full_hd'] !!}" />
                  @endif
                </figure>

                <div class="slider-content mt-1 align-{{ $slide['align'] }}">
                  @if ($slide['title'])
                    <h2 class="content-title">
                      {!! $slide['title'] !!}
                    </h2>
                  @endif
                  @if ($slide['text'])
                    <p class="content-text">
                      {!! $slide['text'] !!}
                    </p>
                  @endif
                  @if ($slide['button'])
                    <div class="wrapper-slider-button">
                      @foreach ($slide['button'] as $button)
                        <a
                          href="{{ $button['video'] }} {{ $button['link']['url'] }}"
                          @if($button['video'])
                            class="glightbox2"
                          @endif
                          target="{{ $button['link']['target'] }}">
                          <button class="slider-button @if(!$button['icon']['url']) no-icon @endif">
                            @if ($button['icon']['url'])
                              <span>
                                <img src="{{ $button['icon']['url'] }}" alt="">
                              </span>
                            @endif
                            <h5 class="button-text @if(!$button['icon']['url']) no-icon @endif">{{ $button['text'] }}</h5>
                          </button>
                        </a>
                      @endforeach
                    </div>
                  @endif
                </div>
              </div>
            @endif
          @endforeach
        </div>
        @if ($wave)
          <span class="waves">
            @svg('images/waves-white.svg')
          </span>
        @endif

        @if ($dots)
          <div class="swiper-pagination @if($dots_hide_mobile)hide-mobile @endif @if($dots_hide_desktop)hide-desktop @endif"></div>
        @endif
      </div>
    @endif
  </div>
@endif