@php
  $section_info_numbers = get_field('section_info_numbers', 'option');
@endphp

<div class="wrapper-info-numbers">
  <a class="brand" href="{{ home_url('/') }}">
    @svg('images/como-logo-colored.svg')
  </a>

  <div class="wrapper-section-info-number">
    <button class="section-mobile-title">
      {!! __('I nostri numeri', 'thor') !!}
      @svg('images/icon-plus-button.svg')
    </button>
    @foreach ($section_info_numbers as $section)
      @if ($section)
        <div class="section-info-number">
          <div class="icon-info">
            <img class="icon-colored active" src="{{$section['image_colored']['url']}}" alt="">
            <img class="icon-monochrome" src="{{$section['image_monochrome']['url']}}" alt="">
          </div>

          <div class="wrapper-text">
            @if ($section['number_link'])
              <a href="tel:{{ $section['number_link'] }}" class="info-number @if($section['emergency'])emergency @endif">{{ $section['number'] }}</a>
            @else
              <span class="info-number @if($section['emergency']) emergency @endif">{{ $section['number'] }}</span>
            @endif
            <h5 class="info-title">{{ $section['title'] }}</h5>
            @if ($section['info_foreign'])
              {!! $section['info_foreign'] !!}
            @endif
            <p class="info-text">{{ $section['text'] }}</p>
          </div>
        </div>
      @endif
    @endforeach
  </div>
</div>