@php
  $post_date = get_the_date( '', get_the_ID() );
  $wp_queried = get_queried_object();
  $comuni = $wp_queried->post_type == "comuni";
  $aqueduct = get_field('aqueduct');
  $sewer = get_field('sewer');
  $depuration = get_field('depuration');
  $services_label = get_field('services_label');
  $green_number_appointment = get_field('green_number_appointment');
  $green_number_time_appointment = get_field('green_number_time_appointment');
  $green_number_customer_care = get_field('green_number_customer_care');
  $email = get_field('email');
  $pec = get_field('pec');
  $next_post = get_next_post();
  $next_post_link = get_permalink($next_post->ID);
  $prev_post = get_previous_post();
  $prev_post_link = get_permalink($prev_post->ID);
  $front_office = get_field('front_office');
  $info_point = get_field('info_point');
@endphp

<article {!! post_class('single-post-wrapper') !!}>
  @include('partials.info-numbers')
  @include('partials.header-second')
  @include('partials.ticker')
  @include('partials/page-header')


  <div class="container thor-maxwidth-lg">
    <div class="date desktop @if($comuni) hide @endif">
      {!! ucfirst($post_date); !!}
    </div>

    <div class="single-post-inner clearfix">
      
      <figure class="main-image lightbox">
        <a href="{!! get_the_post_thumbnail_url(get_the_ID(), 'full') !!}">
          <img
            class="lazy"
            src="{!! get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') !!}"

            data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"

          />
        </a>
      </figure>

      <div class="post-content-wrapper">
        <ul class="services">
          <li class="service">
            <p class="service-name">
              {!! __('Acquedotto', 'thor') !!}
            </p>

            @if ($aqueduct)
              <span>
                @svg('images/icon-check.svg')
              </span>
            @else
              <span>
                @svg('images/icon-x.svg')
              </span>
            @endif
          </li>

          <li class="service">
              <p class="service-name">
                {!! __('Fognatura', 'thor') !!}
              </p>

              @if ($sewer)
                <span>
                  @svg('images/icon-check.svg')
                </span>
              @else
                <span>
                  @svg('images/icon-x.svg')
                </span>
              @endif
          </li>

          <li class="service">
            <p class="service-name">
              {!! __('Depurazione', 'thor') !!}
            </p>

            @if ($depuration)
              <span>
                @svg('images/icon-check.svg')
              </span>
            @else
              <span>
                @svg('images/icon-x.svg')
              </span>
            @endif
          </li>
        </ul>

        <div class="services-label">
          {!! $services_label !!}
        </div>

        <div class="green-number-wrapper">
          @if ($green_number_appointment)
            <div class="green-number">
              <div class="title">
                {!! __('Numero verde prenotazione appuntamento', 'thor') !!}
              </div>

              <div class="number-wrapper">
                <span class="number-icon">
                  @svg('images/phone-green-icon.svg')
                </span>

                <span class="number">
                  {!! $green_number_appointment !!}
                </span>
              </div>

              <div class="label-wrapper">
                <span class="label">
                  {!! $green_number_time_appointment !!}
                </span>
              </div>
            </div>
          @endif

          <div class="green-number">
            @if ($green_number_customer_care)
              <div class="title">
                {!! __('Numero verde servizio clienti', 'thor') !!}
              </div>

              <div class="number-wrapper">
                <span class="number-icon">
                  @svg('images/phone-green-icon.svg')
                </span>

                <span class="number">
                  {!! $green_number_customer_care !!}
                </span>
              </div>
            @endif

            <div class="label-wrapper">
              @if ($email)
                <p class="label">
                  <span>{!! __('email', 'thor') !!}</span>
                  {!! $email !!}
                </p>
              @endif

              @if ($pec)
                <p class="label">
                  <span>{!! __('pec', 'thor') !!}</span>
                  {!! $pec !!}
                </p>
              @endif
            </div>
          </div>
        </div>

        <div class="front-office-wrapper">
          @foreach ($front_office as $office)
            @php
              $address = get_field( 'address', $office->ID );
              $openings = get_field( 'openings', $office->ID );
              $closures = get_field( 'closures', $office->ID );
              $link_maps = get_field( 'link_maps', $office->ID );
              $front_office_name = get_the_title( $office->ID );
            @endphp

            <div class="front-office-time">
              @if ($address)
                <h4 class="front-office-title">
                  {!! __('Sportelli e orari', 'thor') !!}
                </h4>

                <span class="front-office-name">{!! $front_office_name !!} - </span> {!! $address !!}

                <div class="front-office-content">
                  {!! $openings !!}
                </div>
              @endif

              @if ($link_maps)
                <a href="{!! $link_maps['url'] !!}" target="{!! $link_maps['target'] !!}">
                  {!! __('Come raggiungerci', 'thor') !!}
                </a>
              @endif
            </div>

            <div class="front-office-closures">
              @if ($closures)
                <h4 class="front-office-title">
                  {!! __('Chiusure sportelli', 'thor') !!}
                </h4>

                <div class="front-office-content">
                  {!! $closures !!}
                </div>
              @endif
            </div>
          @endforeach
        </div>

        <div class="front-office-wrapper">
          @foreach ($info_point as $point)
            @php
              $info_point_address = get_field( 'info_point_address', $point->ID );
              $info_point_openings = get_field( 'info_point_openings', $point->ID );
              $info_point_link_maps = get_field( 'info_point_link_maps', $point->ID );
              $info_point_name = get_the_title( $point->ID );
            @endphp

            <div class="front-office-time">
              @if ($info_point_address)
                <h4 class="front-office-title">
                  {!! __('Info Point e orari', 'thor') !!}
                </h4>

                <span class="front-office-name">{!! $info_point_name !!} - </span> {!! $info_point_address !!}

                <div class="front-office-content">
                  {!! $info_point_openings !!}
                </div>
              @endif

              @if ($info_point_link_maps)
                <a href="{!! $info_point_link_maps['url'] !!}" target="{!! $info_point_link_maps['target'] !!}">
                  {!! __('Come raggiungerci', 'thor') !!}
                </a>
              @endif
            </div>
          @endforeach
        </div>

        {!! the_content() !!}

        <div class="prev-next-wrapper">
          <a href={!! $prev_post_link !!}>
            <button class="prev">
              {!! __('Indietro', 'thor') !!}
            </button>
          </a>

          <a href={!! $next_post_link !!}>
            <button class="next">
              {!! __('Avanti', 'thor') !!}
            </button>
          </a>
        </div>
      </div>
    </div><!--single-post-inner-->
  </div><!--container-->
</article>
