@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-statistical-numbers-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $bubbles = get_field( 'bubbles' );
  $under_bubbles = get_field( 'under_bubbles' );
  // var_dump($bubbles);

  $wd_block_colors = [
      "primary"         => "#00a5f4",
      "primary-light"  => "#00c1f6",
      "primary-dark" => "#004589",
      "green-500"         => "#4bb817",
      "orange-500"        => "#ff7e16",
      "gray-500"        => "#999999",
      "gray-300"        => "#f5f5f5",
      "white"        => "#fff",
      "black"   => "#000",
  ];

  // foreach( $wd_block_colors as $key => $value ) {
  //     if( $wd_acf_color_picker_values == $value ) {
  //           $wd_color_class = $key;
  //     }
  // }
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">
  @foreach ($bubbles as $bubble)
    @if ($bubble)
      <div class="bubble" style="background-color: {!! $bubble['bubble_color'] !!}">
        <div class="bubble-content">
          @if ($bubble['number_content'])
            <span class="bubble-number" style="color: {!! $bubble['number_color'] !!}">
              {!! $bubble['number_content'] !!}
            </span>
          @endif

          @if ($bubble['label_text'])
            <p class="bubble-label" style="color: {!! $bubble['label_color'] !!}">
              {!! $bubble['label_text'] !!}
            </p>
          @endif
        </div>
      </div>
    @endif
  @endforeach

  <div class="under-bubble-wrapper">
    @foreach ($under_bubbles as $under_bubble)
      @if ($under_bubble)
        <div class="under-bubble">
          @if ($under_bubble['number_content'])
            <span class="under-bubble-number" style="color: {!! $under_bubble['number_color'] !!}">
              {!! $under_bubble['number_content'] !!}
            </span>
          @endif

          @if ($under_bubble['label_text'])
            <p class="under-bubble-label" style="color: {!! $under_bubble['label_color'] !!}">
              {!! $under_bubble['label_text'] !!}
            </p>
          @endif
        </div>
      @endif
    @endforeach
  </div>
</div>
