@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-rates-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $terms = get_terms([
    'taxonomy' => 'rates_year',
    'order' => 'DESC',
  ]);
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className) !!}">
  <ul class="button-taxonomy-wrapper">
    @foreach ($terms as $term)
      <li>
        <button data-target="{{ $term->slug }}" class="button-taxonomy">
          <span>
            {!! __('Tariffe applicate nel', 'thor') !!} {{ $term->name }}
          </span>
        </button>
      </li>
    @endforeach
  </ul>

  <div class="content-table-wrapper">
    @foreach ($terms as $term)
      <div class="rates-panel" data-term="{{ $term->slug }}">
        @include('partials/rates-table', ['term' => $term])
      </div>
    @endforeach
  </div>
</div>