import 'datatables.net'
import 'datatables.net-fixedcolumns'

export default (() => {
  $.fn.DataTable.ext.pager.numbers_length = 5;

  const blocks = $('.thor-water-quality');

  blocks.each( function() {
    const table = $(this).find('.water-quality-table');
    const columns = table.data('columns')
    const data = table.data('data')

    table.DataTable(
      {
        // data,
        // columns,
        fixedColumns: true,
        responsive: true,
        pageLength: 20,
        language: {
          search: '_INPUT_',
          searchPlaceholder: 'Cerca comune',
          zeroRecords: 'Nessun comune trovato',
          paginate: {
            first: '1',
            previous: '<',
            next: '>',
            last: '»',
          },
        },
      }
    );
  })
})();