<?php

namespace App;

/**
 * Theme customizer
 */
add_action('customize_register', function (\WP_Customize_Manager $wp_customize) {
    // Add postMessage support
    $wp_customize->get_setting('blogname')->transport = 'postMessage';
    $wp_customize->selective_refresh->add_partial('blogname', [
        'selector' => '.brand',
        'render_callback' => function () {
            bloginfo('name');
        }
    ]);
});

/**
 * Customizer JS
 */
// add_action('customize_preview_init', function () {
//     wp_enqueue_script('sage/customizer.js', asset_path('scripts/customizer.js'), ['customize-preview'], null, true);
// });


/**
 * Custom login in admin login page
 */
add_filter( 'login_headerurl', function ($url) {
    $siteURL = esc_url(home_url());
    return $siteURL;
}, 10, 2);

/**
 * Custom logo in login page
 */
add_action('login_head', function () {
    $img = asset_path('images/como-logo-white.png');
    echo '<style type="text/css">
    body {
        background-color: #1A1A1A !important;
    }
    h1 a {
        background-image: url('.$img.') !important;
        background-size: contain !important;
        background-position: center !important;
        height: 0 !important;
        padding-bottom: 30% !important;
        width: 80% !important;
    }</style>';
});

/**
 * Custom logo in adminmenu
 */
add_action('admin_head', function () {
    $img = asset_path('images/como-favicon.png');
    echo '<style type="text/css">
    #adminmenu {
        position: relative;
        margin-top: 0;
    }
    
    #adminmenu::before {
        content: "";
        display: block;
        position: relative;
        margin: 0;
        padding: 25px 15px;
        background-color: #26292c;
        background-image: url('.$img.');
        background-size: contain;
        background-position: center;
        background-repeat: no-repeat;
        height: 60px;
    }
    @media screen and (max-width: 960px) and (min-width: 783px) {
        #adminmenu {
            padding: 15px;
            height: auto;
        }
    }
    </style>';
});

/**
 * Custom Footer text in back-end
 */
add_filter('admin_footer_text', function () {
    $theme = wp_get_theme();
    printf(
        __('&#x1F528; Created by <a href="%s" target="_blank">%s</a> from <a href="http://www.wordpress.org" target="_blank">WordPress</a></p>', 'thor'),
        $theme->get( 'AuthorURI' ),
        $theme->get( 'Author' )
    );
}, 10);


/**
 *  Replace Howdy with custom text
 */
add_action( 'admin_bar_menu', function ( $wp_admin_bar ) {
    $user_id = get_current_user_id();
    $current_user = wp_get_current_user();
    $profile_url = get_edit_profile_url( $user_id );
    if ( 0 != $user_id ) :
      /* Add the "My Account" menu */
      $avatar = get_avatar( $user_id, 28 );
      $howdy = sprintf( __('&#128075 %1$s', 'blanka'), $current_user->display_name );
      $class = empty( $avatar ) ? '' : 'with-avatar';

      $wp_admin_bar->add_menu( array(
        'id' => 'my-account',
        'parent' => 'top-secondary',
        'title' => $howdy . $avatar,
        'href' => $profile_url,
        'meta' => array(
        'class' => $class,
        ),
        ));
    endif;
}, 11, 1);




/**
 * Add custon styles button in admin editor
 */
add_filter('mce_buttons_2', function ($buttons) {
    array_unshift($buttons, 'styleselect');
    return $buttons;
});

/**
 * Add custon styles in admin editor
 */
add_filter( 'tiny_mce_before_init', function ( $init_array ) {
    $style_formats = array(
        // Each array child is a format with it's own settings
        array(
            'title' => 'Image full width',
            'block' => 'div',
            'classes' => 'full-width',
            'wrapper' => true,
        ),
        array(
            'title' => 'Image Boxed',
            'block' => 'div',
            'classes' => 'boxed',
            'wrapper' => true,
        ),
        array(
            'title' => 'Image Vertical',
            'block' => 'div',
            'classes' => 'vertical',
            'wrapper' => true,
        )
    );
    // Insert the array, JSON ENCODED, into 'style_formats'
    $init_array['style_formats'] = json_encode( $style_formats );
    return $init_array;
}, 10, 1);


/**
 * Add custon styles button in admin editor
 */

add_action( 'admin_head', function () {
    wp_register_style('blanka_admin_style', asset_path('styles/admin.css'));
    wp_enqueue_style('blanka_admin_style');
});
