@extends('layouts.app')

@section('content')
  @include('partials.info-numbers')
  @include('partials.header-second')
  @include('partials.ticker')

  <div class="container archive-header thor-maxwidth-lg">
    @if ( function_exists('yoast_breadcrumb') )
      @php yoast_breadcrumb( '<p class="breadcrumbs">','</p>' ); @endphp
    @endif
    <h1 class="archive-title">@php single_cat_title() @endphp</h1>
  </div>

  <div class="archive-items">
    <div class="items-wrapper">
      @if (!have_posts())
        <div class="alert alert-warning">
          {{ __('Sorry, no results were found.', LANG_DOMAIN) }}
        </div>
        {!! get_search_form(false) !!}
      @else
        @while (have_posts()) @php the_post() @endphp
          @include('partials.teaser-category')
        @endwhile
        @php wp_reset_postdata() @endphp
      @endif
    </div>
  </div>
@endsection