import 'datatables.net'

export default (() => {
  $.fn.DataTable.ext.pager.numbers_length = 5;

  const blocks = $('.thor-municipality');

  blocks.each( function() {
    const table = $(this).find('.municipality-table');
    const data = table.data('data');
    const columns = table.data('columns')
    const dataLink = [];
    const dataTitle = [];

    data.forEach(element => {
      dataLink.push(element.link);
    });

    data.forEach(element => {
      dataTitle.push(element.title);
    });


    table.DataTable(
      {
        data,
        columns,
        language: {
          search: '_INPUT_',
          searchPlaceholder: 'Cerca comune',
          zeroRecords: 'Nessun comune trovato',
          paginate: {
            first: '1',
            previous: '<',
            next: '>',
            last: '»',
          },
        },
        pageLength: 20,
        columnDefs: [
          {
            visible: false,
            targets: 1,
          },
          {
            targets: 0,
            render: function(data, type, row, meta) {
              return `<a href="${row.link}">${row.title}</a>`;
            },
          },
        ],
      }
    );

  })
})();