import { gsap, Linear } from 'gsap'

export default (() => {
  $(window).on('load', ()=>{
    const ticker = $('.ticker-wrap')
    const tickerWrap = ticker.width();

    const items = document.querySelector('.ticker').cloneNode(true);
    document.getElementById('ticker-wrap').appendChild(items);

    const itemsWidth = items.offsetWidth;

    for (let i = itemsWidth; i < tickerWrap; i += itemsWidth) {
      const items = document.querySelector('.ticker').cloneNode(true);
      document.getElementById('ticker-wrap').appendChild(items);
    }

    let t1 = gsap.timeline();

    t1.to('.ticker', {
      x: -items.offsetWidth,
      repeat: -1, ease: Linear.easeNone, duration: 10,
    });

    ticker.on('mouseenter', ()=>{
      t1.pause()
    })

    ticker.on('mouseleave', () => {
      t1.play()
    })
  })

})();